﻿var openEndCoding = {
    context: $(".v-openEndCoding"),
    datatable: null,
    caseFilter: null,
    notRecoded: false,
    nbOfRecords: 0,
    totalRecords: 0,
    selectedVariables: null,
    selectedVariablesArr: [],
    questionName: null,
    questionCodes: {},
    questionIsMultiMention: false,
    questionMaxAnswers: 1,
    questionCodeWidth: 1,
    initialize: function () {
        caseFilter.getCaseFilter(function (filter, summary) {
            openEndCoding.caseFilter = filter;

            $(".v-caseFilterSummary", openEndCoding.context).html(summary);
        });

        $.when(a4.callServerMethod(a4.getProjectAction("GetOpenEndCodingPageConfiguration", "Data"))).then(function (result) {
            openEndCoding.selectedVariables = result.selectedQuestions;
            openEndCoding.selectedVariablesArr = (result.selectedQuestions) ? result.selectedQuestions.split(',') : [];
            responseValidation.initialize(result);
            $.when.apply($, openEndCoding.loadSelectedQuestionCodes()).then(function () {
                openEndCoding.initializeAutoComplete();
            });
        });
    },
    initializeDataTable: function () {
        openEndCoding.datatable = $(".h-open-end-coding-table", openEndCoding.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getProjectAction("GetOpenEndCodingAnswers", "Data"),
            ajaxParams: { "questionName": openEndCoding.questionName, "variables": openEndCoding.selectedVariables, "caseFilter": caseFilter.getFilterObject() },
            defaultSort: { Column: "CaseId", Ascending: true },
            multiEdit: voxco.security.has('MODIFY_CODE'),
            multiEditExpand: true,
            columns: [
                { "Name": "CaseId", "Title": resources.CaseId, "Data": "CaseId", "HideInSelector": true },
                { "Name": "IntervName", "Title": resources.Interviewer, "Data": "IntervName" },
                { "Name": "IntervId", "Title": resources.InterviewerId, "Data": "IntervId", "Visible": false, "HideInSelector": true }, // Not available for now
                { "Name": "Language", "Title": resources.Language, "Data": "LanguageText", "Type": "enum", "EnumType": "Language" },
                { "Name": "PreCode", "Data": "PreCode", "Title": resources.PreCode, "Sortable": false, "AdvancedFilter": false, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.questionCodes[openEndCoding.questionName]; }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code", "AllowCreate": true } },
                { "Name": "MatrixFormat", "Title": resources.Matrix, "Data": "Matrix", "Type": "enum", "EnumType": "Matrix" },
                { "Name": "Mention", "Title": resources.Mention, "Data": "Mention", "Type": "numeric" },
                { "Name": "Content", "Title": resources.Code, "Data": "Content", "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.questionCodes[openEndCoding.questionName]; }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code", "AllowCreate": true, "MaxItems": 1 } },
                { "Name": "Variable0", "Title": "Variable0", "Data": "Variable0", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(0); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable1", "Title": "Variable1", "Data": "Variable1", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(1); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable2", "Title": "Variable2", "Data": "Variable2", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(2); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable3", "Title": "Variable3", "Data": "Variable3", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(3); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable4", "Title": "Variable4", "Data": "Variable4", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(4); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable5", "Title": "Variable5", "Data": "Variable5", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(5); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable6", "Title": "Variable6", "Data": "Variable6", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(6); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable7", "Title": "Variable7", "Data": "Variable7", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(7); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable8", "Title": "Variable8", "Data": "Variable8", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(8); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                { "Name": "Variable9", "Title": "Variable9", "Data": "Variable9", "Visible": false, "HideInSelector": true, "Type": "multiple", "Editable": { "AvailableValues": function () { return openEndCoding.getQuestionChoices(9); }, "Delimiter": " ", "ValueField": "Code", "LabelField": "Code" } },
                {
                    "Name": "OpenEnd", "Title": resources.OpenEnd, "Data": "OpenEnd", "Class": "full", "render": function (cellData) { return a4.encodeHtml(cellData); }, "Editable": true
                }],
            stateKey: "OpenEndCoding",
            stateSaveSorting: false,
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            allowRowSelection: voxco.security.has('MODIFY_CODE'),
            displayLength: 20,
            toolBarItems: [
                { "Action": "recodeFromList", "Label": resources.RecodeFromCodeList },
                { "Action": "selectVariables", "Label": resources.SelectQuestions, "DisplayMode": dataTables.itemDisplayMode.always }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var caseIds = _.map(rows, function (row) { return row.CaseId });

                switch (action) {
                    case "recodeFromList":
                        openEndCoding.showRecodeFromListSelector();
                        break;
                    case "selectVariables":
                        openEndCoding.showQuestionsSelector();
                        break;
                }
            },
            contextMenuItems: [
                { "Action": "view", "Label": resources.ViewResponses },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "view") {
                    modalDialog.showWindow(a4.getProjectAction("Responses", "Data", { respondentId: row.CaseId }), 680, 1000);
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.NotRecoded, "AjaxParams": { "notRecoded": true } },
                ]
            },
            draw: function () {
                var ajaxParams = openEndCoding.datatable.a4datatable("getAjaxParams");
                openEndCoding.notRecoded = (ajaxParams.notRecoded !== undefined) ? true : false;
                caseFilter.keywordsNotRecoded = openEndCoding.notRecoded;

                openEndCoding.updateNotRecodedCount();
            },
            ready: function () {
                caseFilter.keywordsQuestion = $("#QuestionNameSelected").val();
                openEndCoding.toggleVariableColumns();
            },
            cellCreated: function (evt, data) {
                responseValidation.verifyRowData(data.flagError, data.row, data.rowIndex, data.fieldName, false, false, true, true);
            },
            rowUpdated: function (even, data) {
                var single = true;

                if (data.fieldName == "PreCode") {
                    data.data.EditablePreCode = data.value;
                    single = false;
                }

                data.data.CodeWidth = openEndCoding.questionCodeWidth;

                responseValidation.verifyRowData(data.flagError, data.data, data.index, data.fieldName, true, single, true, true, openEndCoding.questionCodes);
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getProjectAction("UpdateOpenEndCodingAnswers", "Data"), { questionName: caseFilter.keywordsQuestion, openEndCodings: data.rows }, function () {
                    data.multiEditSaveCallback();
                });
            },
            localizableTexts: { "All": resources.AllOpenEnds, "Search": resources.SearchOpenEndsCoding }
        });
    },
    updateNotRecodedCount: function () {
        if (openEndCoding.notRecoded) {
            $("#notRecodedCaseCount").text(openEndCoding.datatable.a4datatable("getTotalRecords"));
        }
        else {
            var tableParams = openEndCoding.datatable.a4datatable("getTableParams");

            var params = {
                "questionName": openEndCoding.questionName,
                "caseFilter": openEndCoding.caseFilter,
                "variables": openEndCoding.selectedVariables
            };

            a4.callServerMethod(a4.getProjectAction("GetNotRecodedCount", "Data"), params, function (result) {
                $("#notRecodedCaseCount").text(result);
            });
        }
    },
    initializeAutoComplete: function () {
        $(".h-openEndQuestion").a4autocomplete({
            ajaxAction: a4.getProjectAction("GetOpenEndQuestions", "Data"),
            valueProperty: "Name",
            labelProperty: "Name",
            altValueField: $("#QuestionNameSelected"),
            required: true,
            select: function (event, ui) {
                if (ui.item) {
                    openEndCoding.questionName = ui.item.Name;
                    openEndCoding.questionIsMultiMention = ui.item.MultipleMention && ui.item.MaxAnswer > 1;
                    openEndCoding.questionMaxAnswers = ui.item.MaxAnswer;
                    openEndCoding.questionCodeWidth = ui.item.CodeWidth;
                    caseFilter.keywords = null;
                    caseFilter.keywordsQuestion = openEndCoding.questionName;

                    var ml = ui.item.MatrixLength;
                    EnumDetails.Matrix = [{ "Label": "1", "Value": "1" }];

                    for (i = 2; i <= ml; i++) {
                        EnumDetails.Matrix.push({ "Label": i.toString(), "Value": i.toString() })
                    }

                    $("#QuestionNameSelected").attr("title", ui.item.CompleteLabel);
                    $("#questionOpenEnd").html(ui.item.CompleteLabel);

                    var initTable = function () {
                        responseValidation.loadSelectedQuestionCodes(openEndCoding.questionName);

                        if (openEndCoding.datatable) {
                            openEndCoding.datatable.a4datatable("destroy");
                        }

                        openEndCoding.initializeDataTable();
                    }

                    if (!openEndCoding.questionCodes[openEndCoding.questionName]) {
                        $.when(a4.callServerMethod(a4.getProjectAction("GetQuestionCodes", "Shared", { questionName: openEndCoding.questionName }))).then(function (result) {
                            openEndCoding.questionCodes[openEndCoding.questionName] = result;
                            initTable();
                        });
                    }
                    else {
                        initTable();
                    }
                }
            },
            create: function () {
                if (!openEndCoding.datatable && openEndCoding.questionName == null) {
                    openEndCoding.initializeDataTable();
                }
            }
        });
    },
    reloadQuestionCodes: function () {
        $.when(a4.callServerMethod(a4.getProjectAction("GetQuestionCodes", "Shared", { questionName: openEndCoding.questionName }))).then(function (result) {
            openEndCoding.questionCodes[openEndCoding.questionName] = result;
            openEndCoding.datatable.a4datatable("triggerChanges");
        });
    },
    loadSelectedQuestionCodes: function () {
        var promises = [];

        _.each(openEndCoding.selectedVariablesArr, function (v) {
            promises.push(a4.callServerMethod(a4.getProjectAction("GetQuestionCodes", "Shared"), { questionName: v }, function (result) {
                openEndCoding.questionCodes[v] = result;
            }));
        });

        return promises;
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    showRecodeFromListSelector: function () {
        var recodeFromListSelectorParams = { questionName: $("#QuestionNameSelected").val() };

        modalDialog.showWindow(a4.getProjectAction("RecodeFromCodeList", "Data", recodeFromListSelectorParams), 500, 700, {});
    },
    showQuestionsSelector: function () {
        modalDialog.showWindow(a4.getProjectAction("OpenEndCodingQuestionsSelector", "Data"), 620, 950, {
            beforeClose: function () {
                var questionSelector = $('.fancybox-iframe').contents();
                var confirmed = questionSelector.find(".v-confirmed").val();
                if (confirmed) {
                    openEndCoding.selectVariables($('.v-selectedQuestions', questionSelector).val());
                }
            }
        });
    },
    selectVariables: function (variables) {
        openEndCoding.selectedVariables = variables;
        openEndCoding.selectedVariablesArr = (variables) ? variables.split(',') : [];

        openEndCoding.loadSelectedQuestionCodes();
        openEndCoding.toggleVariableColumns();

        openEndCoding.datatable.a4datatable("option", "ajaxParams", { "variables": variables });
        openEndCoding.datatable.a4datatable("refresh", true);

        a4.callServerMethod(a4.getProjectAction("UpdateOpenEndCodingPageConfiguration", "Data"), { config: variables }, function (result) { });
    },
    toggleVariableColumns: function () {
        var varArray = [];

        if (openEndCoding.selectedVariables) {
            varArray = openEndCoding.selectedVariables.split(",");
        }

        for (var index = 0; index < 10; index++) {
            var columnName = "Variable" + index;
            var showColumn = varArray[index] != undefined;
            openEndCoding.datatable.a4datatable("toggleColumn", columnName, showColumn);
            openEndCoding.datatable.a4datatable("changeColumnTitle", columnName, varArray[index]);
        }

        openEndCoding.datatable.a4datatable("toggleColumn", "PreCode", openEndCoding.questionIsMultiMention, true);
    },
    getQuestionChoices: function (idx) {
        return openEndCoding.selectedVariablesArr.length > idx ? openEndCoding.questionCodes[openEndCoding.selectedVariablesArr[idx]] : null;
    },
    toggleCaseFilter: function (sectionBox) {
        sectionBox.find(".section-header .fa").toggleClass("fa-caret-down fa-caret-right");
        $(".section-content", sectionBox).toggle();

        if ($(".section-content", sectionBox).is(":visible") || openEndCoding.caseFilter) {
            $(".v-createFilterMessage", sectionBox).hide();
            $(".buttons", sectionBox).show();
        }
        else {
            $(".v-createFilterMessage", sectionBox).show();
            $(".buttons", sectionBox).hide();
        }
    },
    exportFile: function (exportMethod, getFileMethod, params) {
        a4.showBusyBox();

        a4.callServerMethod(exportMethod, params,
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getProjectAction(getFileMethod, "Data", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
    },
    bindEvents: function () {
        openEndCoding.context.on("click", ".h-recode", function () {
            var rows = openEndCoding.datatable.a4datatable("getSelectedItems");
            var respondentCases = [];

            _.each(rows, function (row) {
                respondentCases.push({ CaseId: row.CaseId, Mention: row.Mention });
            });

            var recodeFromListSelectorParams = {
                questionName: $("#QuestionNameSelected", openEndCoding.context).val(),
                respondentCasesJSON: JSON.stringify(respondentCases)
            };

            modalDialog.showWindow(a4.getProjectAction("ApplyRecode", "Data", recodeFromListSelectorParams), 400, 700, {
                afterClose: function () {
                    openEndCoding.refreshContent();
                }
            });
        });

        openEndCoding.context.on("click", ".h-addCodes", function () {
            modalDialog.showWindow(a4.getProjectAction("AddCodeToQuestion", "Data", { questionName: openEndCoding.questionName, codeWidth: openEndCoding.questionCodeWidth }), 500, 700);
        });

        openEndCoding.context.on("click", ".h-exportOpenEndCoding", function () {
            var tableParams = openEndCoding.datatable.a4datatable("getTableParams");

            var params = {
                "tableParams": JSON.stringify(tableParams),
                "caseFilter": (openEndCoding.caseFilter) ? openEndCoding.caseFilter : "",
                "questionName": $("#QuestionNameSelected").val(),
                "notRecoded": openEndCoding.notRecoded
            }

            if (openEndCoding.selectedVariables) {
                params.variables = openEndCoding.selectedVariables;
            }

            var link = a4.getProjectAction("ExportOpenEndCodingCSV", "data");
            openEndCoding.exportFile(link, "GetOpenEndCodingFile", params)
        });

        openEndCoding.context.on("click", ".h-importOpenEndCoding", function () {
            modalDialog.showWindow(a4.getProjectAction("ImportOpenEndCoding", "Data", { questionName: $("#QuestionNameSelected").val() }), 220, 500, {
                afterClose: function () {
                    openEndCoding.refreshContent();
                }
            });
        });

        openEndCoding.context.on("click", ".section-header, .v-createFilterMessage", function () {
            var sectionBox = $(this).closest(".section-box");
            openEndCoding.toggleCaseFilter(sectionBox);
        });

        openEndCoding.context.on("click", ".h-applyFilter", function () {
            caseFilter.getCaseFilter(function (filter, summary) {
                $(".v-caseFilterSummary", openEndCoding.context).html(summary);

                if (filter.IsValid) {
                    openEndCoding.caseFilter = filter;
                    openEndCoding.datatable.a4datatable("option", "ajaxParams", { "caseFilter": filter });
                    openEndCoding.datatable.a4datatable("refresh", true, true);
                }
            });
        });

        openEndCoding.context.on("click", ".h-clearFilter", function () {
            caseFilter.clearCaseFilter();
            caseFilter.initializeCaseFilterAutoComplete();

            if (openEndCoding.caseFilter) {
                openEndCoding.caseFilter = null;

                openEndCoding.updateNotRecodedCount();

                $(".v-caseFilterSummary", openEndCoding.context).html("");
                openEndCoding.datatable.a4datatable("option", "ajaxParams", { "caseFilter": null });
                openEndCoding.datatable.a4datatable("refresh", true, true);

                var sectionBox = $(this).closest(".section-box");

                if (!$(".section-content", sectionBox).is(":visible")) {
                    $(".v-createFilterMessage", sectionBox).show();
                    $(".buttons", sectionBox).hide();
                }
            }
        });
    }
};

$(document).ready(function () {
    if (openEndCoding.context.length > 0) {
        openEndCoding.initialize();
        openEndCoding.bindEvents();
    }
});